<?xml version="1.0" encoding="iso-8859-1"?>
<!--*************************************************************************-->
<!--                                                                         -->
<!-- XSLT Visual Studio importer                                             -->
<!-- Borland Developer Studio                                                -->
<!--                                                                         -->
<!-- Copyright (c) 2003 Borland Software Corporation                         -->
<!--                                                                         -->
<!--*************************************************************************-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- This has to to stay in text mode. Otherwise, my &lt type symbols come -->
<!--   out wrong. XML mode adds a header it can't support which prevents -->
<!--   proper processing. Html doesn't hanlde the & correctly either. -->
<xsl:output method="text" encoding="iso-8859-1" indent="yes"/>

<!-- Adds the XML version header. It must be right up against the template -->
<!-- tag or the post processor complains. -->
<xsl:template match="/">&lt;?xml version="1.0" encoding="utf-8"?&gt;
	<xsl:apply-templates/>
</xsl:template>

<!-- This template creates the root node and begins the processing. -->
<xsl:template match="VisualStudioProject">
	&lt;BorlandProject&gt;
	<!-- Create personality block. -->
	<xsl:call-template name="Personality"/>
	<!-- Process the VS nodes. -->
	<xsl:apply-templates/>
	<!-- Save the unsupported data. -->
	<xsl:call-template name="ImportData"/>
	&lt;/BorlandProject&gt;
</xsl:template>

<!-- Creates the personality block -->
<xsl:template name="Personality">
	&lt;PersonalityInfo&gt;
	&lt;Option&gt;
	<xsl:choose>
	<xsl:when test="/VisualStudioProject/CSHARP">
	&lt;Option Name="Personality" Type="String"&gt;CSharp.Personality&lt;/Option&gt;
	&lt;Option Name="GUID" Type="String"&gt;<xsl:value-of select="/VisualStudioProject/CSHARP/@ProjectGuid"/>&lt;/Option&gt;
	</xsl:when>
	<xsl:when test="/VisualStudioProject/VisualBasic">
	&lt;Option Name="Personality" Type="String"&gt;VB.Personality&lt;/Option&gt;
	&lt;Option Name="GUID" Type="String"&gt;<xsl:value-of select="/VisualStudioProject/VisualBasic/@ProjectGuid"/>&lt;/Option&gt;
	</xsl:when>
	</xsl:choose>

	<!-- This a web application? -->
	<xsl:choose>
	<xsl:when test="string(/VisualStudioProject/CSHARP/@ProjectType)='Web' or string(/VisualStudioProject/VisualBasic/@ProjectType)='Web'">
	&lt;Option Name="ProjectType" Type="String"&gt;AspProject&lt;/Option&gt;
	</xsl:when>
	<xsl:when test="string(/VisualStudioProject/CSHARP/@ProjectType)='Local' or string(/VisualStudioProject/VisualBasic/@ProjectType)='Local'">
	&lt;Option Name="ProjectType" Type="String"&gt;Application&lt;/Option&gt;
	</xsl:when>
	</xsl:choose>

	&lt;Option Name="Version" Type="String"&gt;2.0&lt;/Option&gt;
	&lt;/Option&gt;
	&lt;/PersonalityInfo&gt;
</xsl:template>

<!-- Adds CSHARP personality tags before passing the processing to it's child nodes. -->
<xsl:template match="CSHARP">
	&lt;CSharp.Personality&gt;
	<xsl:apply-templates/>
	&lt;/CSharp.Personality&gt;
</xsl:template>

<!-- Adds VB personality tags before passing the processing to it's child nodes. -->
<xsl:template match="VisualBasic">
	&lt;VB.Personality&gt;
	<xsl:apply-templates/>
	&lt;/VB.Personality&gt;
</xsl:template>

<!-- This rule passes on processing to its child nodes -->
<xsl:template match="Build">
	<xsl:call-template name="Settings"/>
</xsl:template>

<!-- Processing rules for creating the project file list. -->
<xsl:template match="Files">
	&lt;FileList&gt;
	<!-- Process from the references node list first. -->
	<xsl:call-template name="References"/>
	<!-- Continue through the VS node list. -->
	<xsl:apply-templates/>
	&lt;/FileList&gt;
</xsl:template>

<!-- Adds the parent tag, a Selected Options tag, and then passes on processing to it's child nodes. -->
<xsl:template name="Settings">
	<!-- Options tag -->
	&lt;Options&gt;
	<!-- Selected options set tag -->
	&lt;SelectedOptionSet Name="OptionsSet" Type="String"&gt;<xsl:value-of select="./Settings/Config/@Name"/>&lt;/SelectedOptionSet&gt;
	<!-- End Options tag -->
	<xsl:apply-templates/>
	<!-- End Options tag -->
	&lt;/Options&gt;
</xsl:template>

<!-- Adds reference 'assemblies' to the file project list. -->
<xsl:template name="References">
	<xsl:for-each select="/VisualStudioProject/CSHARP/Build/References/*">
		<xsl:call-template name="Add-References"/>
	</xsl:for-each>
	<xsl:for-each select="/VisualStudioProject/VisualBasic/Build/References/*">
		<xsl:call-template name="Add-References"/>
	</xsl:for-each>
</xsl:template>

<!-- Adds private (copy-local) CSHARP reference 'assemblies' to the file project list. -->
<xsl:template name="Add-References">
	<!-- Turns on the Copy local flag if Private is defined -->
	<xsl:variable name="CopyLocal"><xsl:if test="@Private">CopyLocal="<xsl:value-of select="@Private"/>" </xsl:if></xsl:variable>

	<xsl:choose>
	<xsl:when test="string(@WrapperTool)='tlbimp'">
	&lt;File FileName="<xsl:value-of select="@Name"/>" ContainerId="DotNetAssemblyCompiler" ModuleName="<xsl:value-of select="@Name"/>" AssemblyName="<xsl:value-of select="@Name"/>" Guid="<xsl:value-of select="@Guid"/>" WrapperTool="<xsl:value-of select="@WrapperTool"/>" Lcid="<xsl:value-of select="@Lcid"/>" Version="<xsl:value-of select="@VersionMajor"/>.<xsl:value-of select="@VersionMinor"/>" <xsl:value-of select="$CopyLocal"/>/&gt;
	</xsl:when>
	<xsl:when test="string(@WrapperTool)='primary'">
	&lt;File FileName="ComImports\Interop.<xsl:value-of select="@Name"/>.dll" ContainerId="DotNetAssemblyCompiler" ModuleName="Interop.<xsl:value-of select="@Name"/>" Guid="<xsl:value-of select="@Guid"/>" WrapperTool="tlbimp" Lcid="<xsl:value-of select="@Lcid"/>" Version="<xsl:value-of select="@VersionMajor"/>.<xsl:value-of select="@VersionMinor"/>" <xsl:value-of select="$CopyLocal"/>/&gt;
	</xsl:when>
	<xsl:when test="string(@WrapperTool)='aximp'">
	&lt;File FileName="ComImports\Interop.<xsl:value-of select="@Name"/>.dll" ContainerId="DotNetAssemblyCompiler" ModuleName="Interop.<xsl:value-of select="@Name"/>" Guid="<xsl:value-of select="@Guid"/>" WrapperTool="aximp" Lcid="<xsl:value-of select="@Lcid"/>" Version="<xsl:value-of select="@VersionMajor"/>.<xsl:value-of select="@VersionMinor"/>" <xsl:value-of select="$CopyLocal"/>/&gt;
	</xsl:when>
	<xsl:when test="@HintPath">
	&lt;File FileName="<xsl:value-of select="@HintPath"/>" ContainerId="DotNetAssemblyCompiler" ModuleName="<xsl:value-of select="@Name"/>" AssemblyName="<xsl:value-of select="@AssemblyName"/>" <xsl:value-of select="$CopyLocal"/>/&gt;
	</xsl:when>
	<xsl:when test="@Project">
	<xsl:variable name="ProjectGuid">Project="<xsl:choose><xsl:when test="contains(@Project, '|')"><xsl:value-of select="substring-before(@Project,'|')"/></xsl:when><xsl:otherwise><xsl:value-of select="@Project"/></xsl:otherwise></xsl:choose>" </xsl:variable>
	&lt;File FileName="<xsl:value-of select="@Name"/>" ContainerId="DotNetAssemblyCompiler" ModuleName="<xsl:value-of select="@Name"/>" AssemblyName="<xsl:value-of select="@Name"/>" <xsl:value-of select="$ProjectGuid"/> <xsl:value-of select="$CopyLocal"/>/&gt;
	</xsl:when>
	<xsl:when test="@AssemblyName">
	&lt;File FileName="<xsl:value-of select="@AssemblyName"/>.dll" ContainerId="DotNetAssemblyCompiler" ModuleName="<xsl:value-of select="@Name"/>" AssemblyName="<xsl:value-of select="@AssemblyName"/>" <xsl:value-of select="$CopyLocal"/>/&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;File FileName="<xsl:value-of select="@Name"/>.dll" ContainerId="DotNetAssemblyCompiler" ModuleName="<xsl:value-of select="@Name"/>" AssemblyName="<xsl:value-of select="@Name"/>" <xsl:value-of select="$CopyLocal"/>/&gt;
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- This rule passes on processing to it's child nodes -->
<xsl:template match="Include">
	<xsl:apply-templates/>
</xsl:template>

<!-- This rule saves the files in the file nodes of the import -->
<xsl:template match="File">
	<!-- This variable may contain a parent attribute and value or an empty string-->
	<xsl:variable name="FileParentNode"><xsl:if test="@DependentUpon">Parent="<xsl:value-of select="@DependentUpon"/>"</xsl:if></xsl:variable>

	<!-- InternalFileName -->
	<xsl:variable name="InternalFileName"><xsl:choose><xsl:when test="@Link"><xsl:value-of select="@Link"/></xsl:when><xsl:otherwise><xsl:value-of select="@RelPath"/></xsl:otherwise></xsl:choose></xsl:variable>

	<!-- PathStrippedFileName -->
	<xsl:variable name="PathStrippedFileName">
	<xsl:call-template name="StripPath">
		<xsl:with-param name="Module" select="$InternalFileName"/>
	</xsl:call-template>
	</xsl:variable>

	<!-- InternalModuleName -->
	<xsl:variable name="InternalModuleName">
	<xsl:choose>
	<xsl:when test="contains($PathStrippedFileName, '.')">
	<xsl:value-of select="substring-before($PathStrippedFileName,'.')"/>
	</xsl:when>
	<xsl:otherwise>
	<xsl:value-of select="$PathStrippedFileName"/>
	</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>

	<!-- FileName -->
	<xsl:variable name="FileName">FileName="<xsl:value-of select="$InternalFileName"/>" </xsl:variable>

	<!-- ModuleName -->
	<xsl:variable name="ModuleName">ModuleName="<xsl:value-of select="$InternalModuleName"/>" </xsl:variable>

	<!-- RootComponentClassName -->
	<xsl:variable name="CSRootComponentClassName">RootComponentClassName="<xsl:value-of select="/VisualStudioProject/CSHARP/Build/Settings/@RootNamespace"/>.<xsl:value-of select="$InternalModuleName"/>" </xsl:variable>
	<xsl:variable name="VBRootComponentClassName">RootComponentClassName="<xsl:value-of select="/VisualStudioProject/VisualBasic/Build/Settings/@RootNamespace"/>.<xsl:value-of select="$InternalModuleName"/>" </xsl:variable>

	<!-- IsWebReference: If this is true, the module is a web reference -->
	<xsl:variable name="IsWebReference">
		<xsl:call-template name="FindWebReferenceMatch">
			<xsl:with-param name="Module" select="$InternalFileName"/>
		</xsl:call-template>
	</xsl:variable>

	<xsl:choose>
	<xsl:when test="string(@BuildAction)='Compile'">
		<xsl:choose>
		<xsl:when test="string(@SubType)='ASPXCodeBehind' and /VisualStudioProject/CSHARP">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="CSharpCompiler" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Web.UI.Page" <xsl:value-of select="$CSRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="string(@SubType)='ASPXCodeBehind' and /VisualStudioProject/VisualBasic">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="VBTool" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Web.UI.Page" <xsl:value-of select="$VBRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="contains($FileName,'.asax.cs')">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="CSharpCompiler" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Web.HttpApplication" <xsl:value-of select="$CSRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="contains($FileName,'.asax.vb')">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="VBTool" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Web.HttpApplication" <xsl:value-of select="$VBRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="string(@SubType)='Form' and /VisualStudioProject/CSHARP">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="CSharpCompiler" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Windows.Forms.Form" <xsl:value-of select="$CSRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="string(@SubType)='Form' and /VisualStudioProject/VisualBasic">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="VBTool" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Windows.Forms.Form" <xsl:value-of select="$CSRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="/VisualStudioProject/CSHARP">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="CSharpCompiler" <xsl:value-of select="$ModuleName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="/VisualStudioProject/VisualBasic">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="VBTool" <xsl:value-of select="$ModuleName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		</xsl:choose>
	</xsl:when>
	<xsl:when test="string(@BuildAction)='EmbeddedResource'">
	&lt;File <xsl:value-of select="$FileName"/> <xsl:value-of select="$ModuleName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
	</xsl:when>
	<xsl:when test="string(@BuildAction)='Content'">
		<xsl:choose>
		<xsl:when test="/VisualStudioProject/CSHARP/Build/References/Reference[@Name=$InternalModuleName] or /VisualStudioProject/VisualBasic/Build/References/Reference[@Name=$InternalModuleName]">
			<!-- Ignore this condition -->
		</xsl:when>
		<xsl:when test="string(@SubType)='Component' and /VisualStudioProject/CSHARP">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="AspMarkupContainer" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Web.HttpApplication" <xsl:value-of select="$CSRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="string(@SubType)='Component' and /VisualStudioProject/VisualBasic">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="AspMarkupContainer" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Web.HttpApplication" <xsl:value-of select="$VBRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="string(@SubType)='Form' and /VisualStudioProject/CSHARP">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="AspMarkupContainer" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Web.UI.Page" <xsl:value-of select="$CSRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:when test="string(@SubType)='Form' and /VisualStudioProject/VisualBasic">
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="AspMarkupContainer" <xsl:value-of select="$ModuleName"/> FileTypeString="System.Web.UI.Page" <xsl:value-of select="$VBRootComponentClassName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
		</xsl:when>
		<xsl:otherwise>
			&lt;File <xsl:value-of select="$FileName"/> ContainerId="" <xsl:value-of select="$ModuleName"/> <xsl:value-of select="$FileParentNode"/> BuildAction="<xsl:value-of select="@BuildAction"/>"/&gt;
		</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
	<!-- <xsl:when test="string(@BuildAction)='None' and starts-with(@RelPath,'Web Reference')"> -->
	<xsl:when test="boolean(string-length($IsWebReference))">

	<!-- Search the Folder elements for a matching Web Reference. Make that the parent -->
	<xsl:variable name="InternalWebParent"><xsl:for-each select="../Folder"><xsl:if test="starts-with($InternalFileName, @RelPath) and @WebReferenceUrl"><xsl:value-of select="@RelPath"/></xsl:if></xsl:for-each></xsl:variable>
	<!-- Microsoft always ends there web reference folders with a '/' or '\'. This code -->
	<!--	removes the final character and adds the attribute name and quotes -->
	<xsl:variable name="WebParent"><xsl:if test="string-length($InternalWebParent) > 0">Parent="<xsl:value-of select="substring($InternalWebParent, 0, string-length($InternalWebParent))"/>" </xsl:if></xsl:variable>

	<!-- Custom tool for Generator (.map) files -->
	<xsl:variable name="CustomTool"><xsl:if test="@Generator">CustomToolNamespace=""</xsl:if></xsl:variable>

	&lt;File <xsl:value-of select="$FileName"/> ContainerId="WebRefCreator" <xsl:value-of select="$WebParent"/> <xsl:value-of select="$CustomTool"/> /&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;File <xsl:value-of select="$FileName"/> ContainerId="" <xsl:value-of select="$ModuleName"/> <xsl:value-of select="$FileParentNode"/>/&gt;
	</xsl:otherwise>
	</xsl:choose>

	<xsl:apply-templates/>
</xsl:template>

<!-- This rule strips off the path info for creating module names -->
<xsl:template name="StripPath">
	<xsl:param name="Module"/>
	<xsl:choose>
	<xsl:when test="contains($Module,'/')">
		<xsl:call-template name="StripPath">
			<xsl:with-param name="Module" select="substring-after($Module, '/')"/>
		</xsl:call-template>
	</xsl:when>
	<xsl:when test="contains($Module,'\')">
		<xsl:call-template name="StripPath">
			<xsl:with-param name="Module" select="substring-after($Module, '\')"/>
		</xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:value-of select="$Module"/>
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Searches the Folders nodes looking for matches: As long -->
<!-- as the return value is a string greater than 0, it'sa WebReference -->
<xsl:template name="FindWebReferenceMatch">
	<xsl:param name="Module"/>
	<xsl:for-each select="../Folder">
	<!-- InternalFileName -->
	<xsl:variable name="InternalFileName"><xsl:choose><xsl:when test="@Link"><xsl:value-of select="@Link"/></xsl:when><xsl:otherwise><xsl:value-of select="@RelPath"/></xsl:otherwise></xsl:choose></xsl:variable>
	<xsl:if test="starts-with($Module, $InternalFileName) and @WebReferences">True</xsl:if>
	</xsl:for-each>
</xsl:template>

<!-- Converts folders into Borland enteties. -->
<xsl:template match="Folder">
	<!-- This variable may contain a parent attribute and value or an empty string-->
	<xsl:variable name="FileParentNode"><xsl:if test="@DependentUpon">Parent="<xsl:value-of select="@DependentUpon"/>"</xsl:if></xsl:variable>

	<!-- InternalFileName -->
	<xsl:variable name="InternalFileName"><xsl:choose><xsl:when test="@Link"><xsl:value-of select="@Link"/></xsl:when><xsl:otherwise><xsl:value-of select="@RelPath"/></xsl:otherwise></xsl:choose></xsl:variable>

	<!-- FileName -->
	<xsl:variable name="FileName">FileName="<xsl:value-of select="substring($InternalFileName, 0, string-length($InternalFileName))"/>" </xsl:variable>

	<xsl:if test="@WebReferenceUrl">
	&lt;File <xsl:value-of select="$FileName"/> ContainerId="WebRefCreator" <xsl:value-of select="$FileParentNode"/> WebReferenceUrl="<xsl:value-of select="@WebReferenceUrl"/>" /&gt;
	</xsl:if>
</xsl:template>

<!-- The Options rule converts known Borland enteties. Unknowns are not saved off -->
<xsl:template match="Config">
	<!-- Create the name of the Options set -->
	&lt;OptionsSet Name="<xsl:value-of select="@Name"/>"&gt;

	<!-- Options tag -->
	&lt;Options&gt;

	<!-- DebugInformation -->
	&lt;Options Name="DebugInformation" Type="Boolean"&gt;<xsl:value-of select="@DebugSymbols"/><xsl:value-of select="../@DebugSymbols"/>&lt;/Options&gt;

	<!-- Optimization -->
	&lt;Options Name="Optimization" Type="Boolean"&gt;<xsl:value-of select="@Optimize"/><xsl:value-of select="../@Optimize"/>&lt;/Options&gt;

	<!-- Incremental -->
	<xsl:choose>
	<xsl:when test="@IncrementalBuild">
	&lt;Options Name="Incremental" Type="Boolean"&gt;<xsl:value-of select="@IncrementalBuild"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="../@IncrementalBuild">
	&lt;Options Name="Incremental" Type="Boolean"&gt;<xsl:value-of select="../@IncrementalBuild"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="Incremental" Type="Boolean"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>


	<!-- CheckForOverflowUnderflow -->
	<xsl:choose>
	<xsl:when test="@CheckForOverflowUnderflow">
	&lt;Options Name="Overflow" Type="Boolean"&gt;<xsl:value-of select="@CheckForOverflowUnderflow"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="../@CheckForOverflowUnderflow">
	&lt;Options Name="Overflow" Type="Boolean"&gt;<xsl:value-of select="../@CheckForOverflowUnderflow"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="Overflow" Type="Boolean"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- DocumentationFile -->
	<xsl:choose>
	<xsl:when test="@DocumentationFile">
	&lt;Options Name="DocumentationFile" Type="String"&gt;<xsl:value-of select="@DocumentationFile"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="../@DocumentationFile">
	&lt;Options Name="DocumentationFile" Type="String"&gt;<xsl:value-of select="../@DocumentationFile"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="DocumentationFile" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- ivUnsafes -->
	<xsl:choose>
	<xsl:when test="@AllowUnsafeBlocks">
	&lt;Options Name="ivUnsafe" Type="Boolean"&gt;<xsl:value-of select="@AllowUnsafeBlocks"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="../@AllowUnsafeBlocks">
	&lt;Options Name="ivUnsafe" Type="Boolean"&gt;<xsl:value-of select="../@AllowUnsafeBlocks"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="ivUnsafe" Type="Boolean"&gt;True&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- WarningAsError -->
	<xsl:choose>
	<xsl:when test="@TreatWarningsAsErrors">
	&lt;Options Name="WarningAsError" Type="Boolean"&gt;<xsl:value-of select="@TreatWarningsAsErrors"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="WarningAsError" Type="Boolean"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- Warning -->
	<xsl:choose>
	<xsl:when test="@WarningLevel">
	&lt;Options Name="Warning" Type="Integer"&gt;<xsl:value-of select="@WarningLevel"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="Warning" Type="Integer"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- Defines -->
	<xsl:choose>
	<xsl:when test="@DefineConstants">
	&lt;Options Name="Defines" Type="String"&gt;<xsl:value-of select="@DefineConstants"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="Defines" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- TargetName: Add an extension based on Output type -->
	<xsl:choose>
	<xsl:when test="@AssemblyName">
	&lt;Options Name="TargetName" Type="String"&gt;<xsl:value-of select="@AssemblyName"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="../@AssemblyName">
	&lt;Options Name="TargetName" Type="String"&gt;<xsl:value-of select="../@AssemblyName"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="TargetName" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- TargetType: Convert from MS names to Borland names -->
	<xsl:choose>
	<xsl:when test="string(@OutputType)='WinExe' or string(../@OutputType)='WinExe'">&lt;Options Name="TargetType" Type="String"&gt;Windows&lt;/Options&gt;</xsl:when>
	<xsl:when test="string(@OutputType)='Exe' or string(../@OutputType)='Exe'">&lt;Options Name="TargetType" Type="String"&gt;Console&lt;/Options&gt;</xsl:when>
	<xsl:when test="string(@OutputType)='Library' or string(../@OutputType)='Library'">&lt;Options Name="TargetType" Type="String"&gt;Assembly&lt;/Options&gt;</xsl:when>
	<xsl:otherwise>&lt;Options Name="TargetType" Type="String"&gt;&lt;/Options&gt;</xsl:otherwise>
	</xsl:choose>

	<!-- BaseAddress -->
	<xsl:choose>
	<xsl:when test="@BaseAddress">
	&lt;Options Name="BaseAddress" Type="String"&gt;<xsl:value-of select="@BaseAddress"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="../@BaseAddress">
	&lt;Options Name="BaseAddress" Type="String"&gt;<xsl:value-of select="../@BaseAddress"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="BaseAddress" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- OutputDirectory -->
	<xsl:choose>
	<xsl:when test="@OutputPath">
	&lt;Options Name="OutputDirectory" Type="String"&gt;<xsl:value-of select="@OutputPath"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="OutputDirectory" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- DefaultNamespace -->
	<xsl:choose>
	<xsl:when test="@RootNamespace">
	&lt;Options Name="DefaultNamespace" Type="String"&gt;<xsl:value-of select="@RootNamespace"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="../@RootNamespace">
	&lt;Options Name="DefaultNamespace" Type="String"&gt;<xsl:value-of select="../@RootNamespace"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="DefaultNamespace" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- DefaultStartupObject -->
	<xsl:variable name="StartupObject"><xsl:value-of select="@StartupObject"/><xsl:value-of select="../@StartupObject"/></xsl:variable>
	<xsl:choose>
	<xsl:when test="contains($StartupObject,'.')">
	&lt;Options Name="Main" Type="String"&gt;<xsl:value-of select="substring-after($StartupObject,'.')"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="Main" Type="String"&gt;<xsl:value-of select="$StartupObject"/>&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- RunParams: No translation -->
	<xsl:choose>
	<xsl:when test="@RunParams">
	&lt;Options Name="RunParams" Type="String"&gt;<xsl:value-of select="@RunParams"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="RunParams" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- HostApplication: No translation -->
	<xsl:choose>
	<xsl:when test="/VisualStudioProject/CSHARP and string(/VisualStudioProject/CSHARP/@ProjectType)='Web'">
	&lt;Options Name="HostApplication" Type="String"&gt;http://localhost&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="/VisualStudioProject/VisualBasic and string(/VisualStudioProject/CSHARP/@ProjectType)='Web'">
	&lt;Options Name="HostApplication" Type="String"&gt;http://localhost&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	<xsl:choose>
	<xsl:when test="@HostApplication">
	&lt;Options Name="HostApplication" Type="String"&gt;<xsl:value-of select="@HostApplication"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="HostApplication" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>
	</xsl:otherwise>
	</xsl:choose>

	<!-- Launcher: No translation -->
	<xsl:choose>
	<xsl:when test="@Launcher">
	&lt;Options Name="Launcher" Type="String"&gt;<xsl:value-of select="@Launcher"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="Launcher" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- UseLauncher: No translation -->
	<xsl:choose>
	<xsl:when test="@UseLauncher">
	&lt;Options Name="UseLauncher" Type="Boolean"&gt;<xsl:value-of select="@UseLauncher"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="UseLauncher" Type="Boolean"&gt;False&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- DebugCWD: No translation -->
	<xsl:choose>
	<xsl:when test="@DebugCWD">
	&lt;Options Name="DebugCWD" Type="String"&gt;<xsl:value-of select="@DebugCWD"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="DebugCWD" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- RemotePath: No translation -->
	<xsl:choose>
	<xsl:when test="@RemotePath">
	&lt;Options Name="RemotePath" Type="String"&gt;<xsl:value-of select="@RemotePath"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="RemotePath" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- RemoteHost: No translation -->
	<xsl:choose>
	<xsl:when test="@RemoteHost">
	&lt;Options Name="RemoteHost" Type="String"&gt;<xsl:value-of select="@RemoteHost"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="RemoteHost" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- RemoteLauncher: No translation -->
	<xsl:choose>
	<xsl:when test="@RemoteLauncher">
	&lt;Options Name="RemoteLauncher" Type="String"&gt;<xsl:value-of select="@RemoteLauncher"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="RemoteLauncher" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- RemoteDebug: No translation -->
	<xsl:choose>
	<xsl:when test="@RemoteDebug">
	&lt;Options Name="RemoteDebug" Type="Boolean"&gt;<xsl:value-of select="@RemoteDebug"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
 	&lt;Options Name="RemoteDebug" Type="Boolean"&gt;False&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- Create ASP settings -->
	<xsl:choose>
	<xsl:when test="string(/VisualStudioProject/CSHARP/@ProjectType)='Web' or string(/VisualStudioProject/VisualBasic/@ProjectType)='Web'">
	&lt;Options Name="AspNetUseHostServer" Type="Boolean"&gt;True&lt;/Options&gt;
	&lt;Options Name="AspNetLaunchBrowser" Type="Boolean"&gt;True&lt;/Options&gt;
	&lt;Options Name="AspNetHostServer" Type="String"&gt;Cassini&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="AspNetUseHostServer" Type="Boolean"&gt;False&lt;/Options&gt;
	&lt;Options Name="AspNetLaunchBrowser" Type="Boolean"&gt;False&lt;/Options&gt;
	&lt;Options Name="AspNetHostServer" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>
	&lt;Options Name="AspNetStartPage" Type="String"&gt;<xsl:value-of select="../../../Files/Include/File[@SubType='ASPXCodeBehind']/@DependentUpon"/>&lt;/Options&gt;
	&lt;Options Name="AspNetCassiniVirtualDirectory" Type="String"&gt;&lt;/Options&gt;
	&lt;Options Name="AspNetIISVirtualDirectory" Type="String"&gt;&lt;/Options&gt;
	&lt;Options Name="AspNetHTTPAddress" Type="String"&gt;&lt;/Options&gt;

	<!-- ApplicationIcon -->
	<xsl:choose>
	<xsl:when test="@ApplicationIcon">
	&lt;Options Name="ApplicationIcon" Type="String"&gt;<xsl:value-of select="@ApplicationIcon"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:when test="../@ApplicationIcon">
	&lt;Options Name="ApplicationIcon" Type="String"&gt;<xsl:value-of select="../@ApplicationIcon"/>&lt;/Options&gt;
	</xsl:when>
	<xsl:otherwise>
	&lt;Options Name="ApplicationIcon" Type="String"&gt;&lt;/Options&gt;
	</xsl:otherwise>
	</xsl:choose>

	<!-- BuildInOutput: No translation -->
	&lt;Options Name="BuildInOutput" Type="Boolean"&gt;True&lt;/Options&gt;

	<!-- Options end tag -->
	&lt;/Options&gt;

	<!-- OptionsSet end tag -->
	&lt;/OptionsSet&gt;
</xsl:template>


<!-- Saves Visual Studio data not supported. -->
<xsl:template name="ImportData">
	&lt;ImportData&gt;

	<xsl:choose>
	<!--*********************************-->
	<!-- CSHARP import data. -->

	<xsl:when test="/VisualStudioProject/CSHARP">
	<!--*********************************-->
	<!-- CSHARP Project options. -->

	<!-- Project wide settings -->
	&lt;CSharpProjectOptions
	<xsl:for-each select="/VisualStudioProject/CSHARP/Build/Settings/@*">
	<xsl:value-of select="name()"/>="<xsl:value-of select="."/>"
	</xsl:for-each>
	/&gt;

	<!-- Local overide settings -->
	<xsl:for-each select="/VisualStudioProject/CSHARP/Build/Settings/*">
	&lt;CSharpLocalOptions
	<xsl:for-each select="./@*">
	<xsl:value-of select="name()"/>="<xsl:value-of select="."/>"
	</xsl:for-each>
	/&gt;
	</xsl:for-each>

	</xsl:when>

	<!--*********************************-->
	<!-- VisualBasic import data. -->
	<xsl:when test="/VisualStudioProject/VisualBasic">
	<!--*********************************-->
	<!-- VisualBasic Project options. -->

	<!-- Project wide settings -->
	&lt;VisualBasicProjectOptions
	<xsl:for-each select="/VisualStudioProject/VisualBasic/Build/Settings/@*">
	<xsl:value-of select="name()"/>="<xsl:value-of select="."/>"
	</xsl:for-each>
	/&gt;

	<!-- Local overide settings -->
	<xsl:for-each select="/VisualStudioProject/VisualBasic/Build/Settings/*">
	&lt;VisualBasicLocalOptions
	<xsl:for-each select="./@*">
	<xsl:value-of select="name()"/>="<xsl:value-of select="."/>"
	</xsl:for-each>
	/&gt;
	</xsl:for-each>

	</xsl:when>

	</xsl:choose>
	&lt;/ImportData&gt;
</xsl:template>

</xsl:stylesheet>